RailroadCrossingAddon = {}

function RailroadCrossingAddon:onSplinePositionTimeUpdate(superFunc, startTime, endTime)
	startTime = SplineUtil.getValidSplineTime(startTime) -- startTime: train front
	endTime = SplineUtil.getValidSplineTime(endTime) -- endTime: train rear
	local splineLength = self.trainSystem:getSplineLength()
	
	local locoSpeed = 0.02
	local rootLocomotive = self.trainSystem.spec_trainSystem.rootLocomotive
	if rootLocomotive ~= nil and self.isServer then -- speed is constant 0 as client in mp...
		locoSpeed = rootLocomotive.spec_locomotive.speed/750
	else -- therefore, calculate approx. speed by distance traveled
		local curTime = g_time
		if self.oldStartTime ~= nil and self.oldUpdateTime ~= nil then
			locoSpeed = math.min(((startTime-self.oldStartTime)*splineLength)/((curTime-self.oldUpdateTime)/1000)/750, 0.03) -- speed capped at 81 kph
		end
		self.oldStartTime = startTime
		self.oldUpdateTime = curTime
	end
	
	local inRange = ((self.splinePositionTime - startTime) < locoSpeed and endTime < (self.splinePositionTime+0.001)) or ((self.splinePositionTime - endTime) > locoSpeed and startTime > (self.splinePositionTime-0.001))

	if inRange then
		if self.state == RailroadCrossing.STATE_OPEN or self.state == RailroadCrossing.STATE_OPENING then
			self:startClosingGates()
		end
	elseif self.state == RailroadCrossing.STATE_CLOSED or self.state == RailroadCrossing.STATE_CLOSING then
		self:startOpeningGates()
	end
end

function RailroadCrossingAddon:startClosingGates(superFunc)
	self.state = RailroadCrossing.STATE_CLOSING

	for _, signal in ipairs(self.signals) do
		setVisibility(signal.node, true)
	end

	for _, gate in ipairs(self.gates) do
		if gate.animTime == 0 then
			gate.currentOffset = gate.closingOffset * 3
		end
	end

	self.gateDirection = 1

	if g_client ~= nil and not self.isCrossingSamplePlaying then
		g_soundManager:playSample(self.samples.crossing)

		self.isCrossingSamplePlaying = true
	end

	self:setBlockingPositionsState(true)
end

RailroadCrossing.onSplinePositionTimeUpdate = Utils.overwrittenFunction(RailroadCrossing.onSplinePositionTimeUpdate, RailroadCrossingAddon.onSplinePositionTimeUpdate)
RailroadCrossing.startClosingGates = Utils.overwrittenFunction(RailroadCrossing.startClosingGates, RailroadCrossingAddon.startClosingGates)
